/************************************************************
* Weight Sensor Module(20kg) BMH01220 example code
* Arduino IDE version: 1.8.13
* Arduino Board: UNO R3
* Wire Connection:
*   BMH01220 module pin 1 (GND) connects to UNO pin GND
*   BMH01220 module pin 2 (VDD) connects to UNO pin 5V
*   BMH01220 module pin 3 (SDA) connects to UNO pin SDA (or A4)
*   BMH01220 module pin 4 (SCL) connects to UNO pin SCL (or A5)
* Created on 2022/5/3 by Best Modules Corp.
*************************************************************/

#include <Wire.h> 

#define SLAVE_ADDRESS 0x50        // I2C address of this module
#define MAX 4000                  // maximum calibration value, 4kg

void setup() 
{
  Wire.begin();
  Serial.begin(9600);  
  Write_Zero();
  while(Read_Calibration()!=2)
     {
       Serial.print("zero point calibration status : ");
       switch (Read_Calibration())
       {
          case 0 : Serial.println("Calibration Fail");
                   break;
          case 1 : Serial.println("During zero-point calibration");
                   break; 
          case 2 : Serial.println("Zero-point calibration complete");
                   break; 
          case 5 : Serial.println("During maximum-point calibration");
                   break; 
          case 6 : Serial.println("Maximum-point calibration complete");
                   break; 
          default: Serial.println("Unpredictable");
                   break; 
       }
       delay(1000);
     }
     
  Write_Calibration(MAX);
  while(Read_Calibration()!=6)
     {
       Serial.print("maximum calibration status : ");
       switch (Read_Calibration())
       {
          case 0 : Serial.println("Calibration Fail");
                   break;
          case 1 : Serial.println("During zero-point calibration");
                   break; 
          case 2 : Serial.println("Zero-point calibration complete");
                   break; 
          case 5 : Serial.println("During maximum-point calibration");
                   break; 
          case 6 : Serial.println("Maximum-point calibration complete");
                   break; 
          default: Serial.println("Unpredictable");
                   break; 
       }
       delay(1000);
     }
}

void loop() 
{
  Serial.print("Weight value : ");
  Serial.println(Read_Weight());
  delay(1000);
}

/*************************************************
Description: Read AD value (test mode)

Return: AD value    
*************************************************/
uint16_t Read_Adc(void)
{    
      uint8_t Buffer[2],counter=0;
      uint16_t data;
      Wire.beginTransmission(SLAVE_ADDRESS);    // Send start command and Slave Address
      Wire.write(0xAD); 
      Wire.endTransmission(false);              // transmission with an I2C restart   
      delay(10);                                // time required before reading data 
      Wire.requestFrom(SLAVE_ADDRESS,2);        // Send a request to return 3 bytes data from a slave device
      while(Wire.available())
      {
        Buffer[counter++] = Wire.read();        // Returns the number of bytes available for retrieval with read()
        delay(100);
        if(counter==2)break;
      }
      data=Buffer[0]*256 + Buffer[1];           // Data =  Data_HighByte + Data_LowByte;  
      return data;  
}

/*************************************************
Description: Read Weight value

Return: Weight value    
*************************************************/
uint16_t Read_Weight(void)
{    
      uint8_t Buffer[2],counter=0;
      uint16_t data;
      Wire.beginTransmission(SLAVE_ADDRESS);    // Send start command and Slave Address
      Wire.write(0xAE); 
      Wire.endTransmission(false);              // transmission with an I2C restart   
      delay(10);                                // time required before reading data 
      Wire.requestFrom(SLAVE_ADDRESS,2);        // Send a request to return 3 bytes data from a slave device
      while(Wire.available())
      {
        Buffer[counter++] = Wire.read();        // Returns the number of bytes available for retrieval with read()
        if(counter==2)break;
      }
      data=Buffer[0]*256 + Buffer[1];           // Data =  Data_HighByte + Data_LowByte;  
      return data;  
}

/*************************************************
Description: Read Calibration value

Return: Calibration value    

Note: value = 0 : Calibration Fail
      value = 1 : During zero-point calibration
      value = 2 : Zero-point calibration complete
      value = 5 : During maximum-point calibration
      value = 6 : Maximum-point calibration complete
*************************************************/
uint8_t Read_Calibration(void)
{    
      uint8_t Buffer[1],counter=0;
      Wire.beginTransmission(SLAVE_ADDRESS);   // Send start command and Slave Address
      Wire.write(0xCA); 
      Wire.endTransmission(false);             // transmission with an I2C restart   
      delay(10);                               // time required before reading data 
      Wire.requestFrom(SLAVE_ADDRESS,1);       // Send a request to return 1 byte data from a slave device
      while(Wire.available())
      {
        Buffer[counter++] = Wire.read();       // Returns the number of bytes available for retrieval with read()
        if(counter==1)break;
      }
      return Buffer[0];  
}

/*************************************************
Description: Enter sleep mode 
*************************************************/
void Write_Sleep(void)
{
      Wire.beginTransmission(SLAVE_ADDRESS);    // Send start cmd and Slave Address
      Wire.write(0xC0);   
      Wire.write(0xAA);    
      Wire.endTransmission();                   // transmission with an I2C stop 
}

/*************************************************
Description: Calibrate zero point
*************************************************/
void Write_Zero(void)
{
      uint8_t count=0;
      Wire.beginTransmission(SLAVE_ADDRESS);    // Send start cmd and Slave Address
      Wire.write(0xCA);   
      Wire.write(0);   
      Wire.write(0);  
      Wire.endTransmission();                   // transmission with an I2C stop     
}

/*************************************************
Description: Calibrate maximum point

Parameter: maximum point calibration
*************************************************/
void Write_Calibration(uint16_t value)
{
      uint8_t count=0;
      uint8_t cal_h=(uint8_t)(value>>8);       // High Byte of value
      uint8_t cal_l=(uint8_t)(value&0xFF);     // Low Byte of value
      Wire.beginTransmission(SLAVE_ADDRESS);    // Send start cmd and Slave Address
      Wire.write(0xCA);   
      Wire.write(cal_h);   
      Wire.write(cal_l);   
      Wire.endTransmission();                   // transmission with an I2C stop   
}
